<?php
if ( ! isset( $content_width ) )
	$content_width = 480;

add_action( 'after_setup_theme', 'websitez_setup' );
add_action( 'after_setup_theme', 'websitez_insert_analytics' );
add_action( 'after_setup_theme', 'websitez_insert_header_ad' );
add_action( 'after_setup_theme', 'websitez_insert_footer_ad' );
add_action( 'after_setup_theme', 'websitez_insert_logo' );
add_filter('pre_get_posts', 'websitez_post_results');

function websitez_post_results($query){
	$options = websitez_get_options();
	if(is_numeric($options['general']['posts_per_page']) && $options['general']['posts_per_page'] > 0){
		$query->query_vars['posts_per_page'] = $options['general']['posts_per_page'];
	}
	return $query;
}

function websitez_insert_logo(){
	if (is_feed()){
		return;
	}

	ob_start("websitez_insert_logo_now");
}

function websitez_insert_logo_now($html){
	$options = websitez_get_options();
	if($options && strlen($options['images']['logo']) > 0){
		$html = preg_replace("/<a.*class=\"logo\">(.*?)<\/a>/im", "<a href='".get_bloginfo('url')."' class='logo'><img src='".$options['images']['logo']."' border='0' alt=''></a>", $html);
	}
	return $html;
}

function websitez_insert_header_ad(){
	if (is_feed()){
		return;
	}

	ob_start("websitez_insert_header_ad_now");
}

function websitez_insert_footer_ad(){
	if (is_feed()){
		return;
	}

	ob_start("websitez_insert_footer_ad_now");
}

function websitez_insert_analytics(){
	if (is_feed()){
		return;
	}

	ob_start("websitez_insert_analytics_now");
}

function websitez_get_options(){
	return unserialize(get_option('websitez-options'));
}

function websitez_insert_header_ad_now($html){
	$options = websitez_get_options();
	if($options['ads']['show_header'] == "yes")
		$html = preg_replace("/<body(.*?)>/im", "<body>\n".stripslashes($options['ads']['show_header_snippet']), $html);
	return $html;
}

function websitez_insert_footer_ad_now($html){
	$options = websitez_get_options();
	if($options['ads']['show_footer'] == "yes")
		$html = preg_replace("/<\/body>/im", stripslashes($options['ads']['show_footer_snippet'])."\n</body>", $html);
	return $html;
}

function websitez_insert_analytics_now($html){
	$options = websitez_get_options();
	if($options['analytics']['show_analytics'] == "yes")
		$html = preg_replace("/<\/body>/im", stripslashes($options['analytics']['show_analytics_snippet'])."\n</body>", $html);
	return $html;
}

/*
Dynamically load stylesheet
*/
add_action( 'wp_print_styles', 'websitez_stylesheet');
if (!function_exists('websitez_setup')){
	function websitez_stylesheet() {
		$myStyleUrl = get_bloginfo('template_url').'/style.php';
		wp_register_style('websitez-custom-stylesheet', $myStyleUrl);
		wp_enqueue_style( 'websitez-custom-stylesheet');
	}
}

if (!function_exists('websitez_setup')){
	function websitez_setup() {
		// Add default posts and comments RSS feed links to head
		add_theme_support( 'automatic-feed-links' );
	}
}

function websitez_comment($comment, $args, $depth){
	$GLOBALS['comment'] = $comment;
?>
	<div class="websitez-comments" <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
		<div class="websitez-comments-author">
			<p class="websitez-comments-gravatar"><?php  if(function_exists('get_avatar')){ echo get_avatar($comment, '80'); } ?></p>
			<p class="websitez-comments-author-link"><?php  comment_author_link() ?></p>
		</div>
		<?php if ($comment->comment_approved == '0') : ?>
	   	<p class="websitez-comments-awaiting-moderation"><?php _e('This comment is awaiting moderation.'); ?></p>
	  <?php endif; ?>
		<p class="websitez-comments-text"><?php comment_text() ?></p>
		<p class="websitez-comments-reply"><?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?></p>
		<div style="clear: both;"></div>
	</div>
<?php
}
?>
<?php
//[checklist] shortcode adds checklist div to content contained inside
	function checklist($atts, $content = null) {
	return '<div class="checklist">'.$content.'</div>';
	}
	add_shortcode('checklist', 'checklist');
//[listservices] shortcode adds a class of checklist to a list of the services pages
	function listservices() {
	$list = wp_list_pages("title_li=&child_of=137&depth=1&echo=0");
    return '<div class="checklist"><ul>'.$list.'</ul></div>';
	}
	add_shortcode('listservices', 'listservices');
	
?>