<?php
/*
Plugin Name: Empty Plugin (Widget)
Plugin URI: http://trepmal.com/
Description: Does nothing - testing only
Author: Kailey Lampert
Version: 0.0
Author URI: http://kaileylampert.com/
*/
/*
    Copyright (C) 2010  Kailey Lampert

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

add_action( 'widgets_init', 'awd_custom_post_load' ); /* Add our function to the widgets_init hook. */
function awd_custom_post_load() { register_widget( 'awd_custom_posts' ); } /* Function that registers our widget. */

class awd_custom_posts extends WP_Widget {

        function awd_custom_posts() {
                $widget_ops = array( 'classname' => 'awd_custom_posts', 'description' => 'Display Custom Posts' ); /* Widget settings. */
                $control_ops = array( 'width' => 450, 'height' => 250, 'id_base' => 'awd_custom_posts' ); /* Widget control settings. */
                $this->WP_Widget( 'awd_custom_posts', 'Display Custom Posts', $widget_ops, $control_ops ); /* Create the widget. */
    }

        function widget( $args, $instance ) {
                extract( $args );

                echo $before_widget; /* Before widget (defined by themes). */

                if ( $instance['title'] ) echo $before_title . $instance['title'] . $after_title; /* Title of widget (before and after defined by themes). */

                echo '<ul>';
                foreach($instance as $name=>$value) {
                        if ($name == 'title') continue;
                        echo '<li>' . $name . ': ' . $value . '</li>';
                }
                echo '</ul>';

                echo $after_widget; /* After widget (defined by themes). */
        }

        function update( $new_instance, $old_instance ) {
                $instance = $old_instance;

                foreach($new_instance as $k=>$v) { $instance[$k] = strip_tags($v); } /* Strip tags (if needed) and update the widget settings. */

                return $instance;
        }

        function form( $instance ) {

                /* Set up some default widget settings. */

                $defaults = array('title' => 'Display Custom Posts', 'content' => 'Input some text here');

                $instance = wp_parse_args( (array) $instance, $defaults );

                echo '<p><label for="'.$this->get_field_id( 'title' ).'">'. 'Title'.'</label><br />
                                        <input type="text" id="'. $this->get_field_id( 'title' ).'" name="'.$this->get_field_name( 'title' ).'" value="'.$instance['title'].'" /></p>';

                echo '<p><label for="'.$this->get_field_id( 'content' ).'">'. 'Content'.'</label><br />
                                        <input type="text" id="'. $this->get_field_id( 'content' ).'" name="'.$this->get_field_name( 'content' ).'" value="'.$instance['content'].'" /></p>';

        } //end function
} //end class 

?>